{include file="mheader.tpl" meta_title="Deposit List"}
<!-- Page wrapper  -->
<div class="page-wrapper">
    <!-- Bread crumb -->
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-primary">Deposit List</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item active">Deposit List</li>
            </ol>
        </div>
    </div>
    <!-- End Bread crumb -->
    <!-- Container fluid  -->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12 text-left">
                <div class="card p-30 bg-primary">
                    <h5 class="text-white">Your deposits</h5>

                    <div class="card-body">


                        <b>Total: {$currency_sign}{$total}</b><br><br>


<div class="table-responsive">


{foreach from=$plans item=p}
<table cellspacing=1 cellpadding=2 border=0 width=100% class="table table-centered m-0">
    <tr><td class=item>
<table cellspacing=1 cellpadding=2 border=0 width=100% class="table table-centered bg-warning m-0">
<tr>
 <td colspan=3 align=center><div class="alert alert-success" role="alert" style="text-align: center;
"><b>{$p.name}</b></div></td>
</tr><tr class="thead-dark">
 <th class=inheader>Plan</th>
 <th class=inheader width=200>Deposit Amount</th>
 <th class=inheader width=100 nowrap><nobr>{$p.period} Profit (%)</nobr></th>
</tr>
{foreach from=$p.plans item=o}
<tr>
 <td class=item>{$o.name}</td>
 <td class=item align=right>{$currency_sign}{$o.min_deposit} {if $o.max_deposit>0}- {$currency_sign}{$o.max_deposit}{else}and more{/if}</td>
 <td class=item align=right>{$o.percent}</td>
</tr>
{/foreach}
</table>
<br>
<table cellspacing=1 cellpadding=2 border=0  class="table table-centered bg-warning m-0">
{if !$p.deposits}
<tr>
<td colspan=4><div class="alert alert-danger" role="alert"><b>No deposits for this plan</b></div></td>
</tr>           
{else}
<tr>
 <td colspan=4 class=inheader style="text-align:left">Your deposits:</td>
</tr>
<tr>
 <td class=inheader>Date</td>
 <td class=inheader>Amount</td>
{if $p.use_compound}
 <td class=inheader>Compounding Percent</td>
{/if}
{if $p.withdraw_principal}
 <td class=inheader>Release</td>
{/if}
</tr>           
{foreach from=$p.deposits item=d}
<tr>
 <td align=center class=item><b>{$d.date}</b><br>{if $p.q_days == 0}Working {$d.duration} days{else}Expire in {$d.expire_in}{/if}</td>
 <td align=center class=item><b>{$d.deposit|fiat:$d.ec} <img src="images/{$d.ec}.gif" align=absmiddle hspace=1 height=17></b></td>


{if $p.use_compound}
 <td align=center class=item align=center>{$d.compound}% <a href="{"?a=change_compound&deposit=`$d.id`"|encurl}">[change]</a></td>
{/if}
{if $p.withdraw_principal}
 <td align=center class=item>
  {if $d.can_withdraw}
   <a href="{"?a=withdraw_principal&deposit=`$d.id`"|encurl}">[release]</a>
  {else}
   {if $d.pending_duration > 0}
    {$d.pending_duration} day{if $d.pending_duration > 1}s{/if} left
   {else}
    not available
   {/if}
  {/if}
 </td>
{/if}
</tr>
{/foreach}
{/if}
</table>
{if $p.total_deposit > 0 || $p.today_profit > 0 || $p.total_profit > 0}
<table cellspacing=0 cellpadding=1 border=0>
<tr><td>Deposited Total:</td><td><b>{$p.total_deposit|fiat}</b></td></tr>
<tr><td>Profit Today:</td><td><b>{$p.today_profit|fiat}</b></td></tr>
<tr><td>Total Profit:</td><td><b>{$p.total_profit|fiat}</b></td></tr>
</table>
{/if}
<br>
</td></tr></table>
<br>
{/foreach}
</div></div></div></div></div>
{include file="mfooter.tpl"}
