/**
 * crisp-client
 * @version v2.7.0 370c9ed
 * @author Crisp IM SAS
 * @date 3/24/2022
 */
window.$crisp.__spool.locale_handler({
    xi: {
        locale_name: "English",
        locale_code: "en",
        locale_direction: "ltr"
    },
    Ei: {
        date: {
            hour_singular: "An hour ago",
            hour_plural: "%1s hours ago",
            minute_singular: "A minute ago",
            minute_plural: "%1s minutes ago",
            second: "A few seconds ago",
            now: "Just now"
        },
        duration: {
            days: "A few days",
            hour_singular: "An hour",
            hour_plural: "%1s hours",
            minute_singular: "A minute",
            minute_plural: "%1s minutes",
            second: "A few seconds",
            now: "Instantly"
        },
        days: {
            monday: "Monday",
            tuesday: "Tuesday",
            wednesday: "Wednesday",
            thursday: "Thursday",
            friday: "Friday",
            saturday: "Saturday",
            sunday: "Sunday"
        },
        months: {
            january: "January",
            february: "February",
            march: "March",
            april: "April",
            may: "May",
            june: "June",
            july: "July",
            august: "August",
            september: "September",
            october: "October",
            november: "November",
            december: "December"
        },
        theme_text: {
            default_chat: "Questions? Chat with us!",
            "1_chat": "Questions? Chat with me!",
            "2_chat": "Ask us your questions",
            "3_chat": "Ask me your questions",
            "4_chat": "Chat with support"
        },
        theme_welcome: {
            default_chat: "How can we help with %1s?",
            "1_chat": "Hey, want to chat with us?",
            "2_chat": "Anything you want to ask?",
            "3_chat": "Hello, ask us any question about %1s.",
            "4_chat": "Hello! How can I help you? :)",
            "5_chat": "Any question about %1s?"
        },
        minimized: {
            unauthorized_pane: "Invalid website",
            tooltip_entice_status_online: "Support is online.",
            tooltip_entice_status_away: "Support is away.",
            tooltip_entice_full_chat: "Chat with %1s Team",
            tooltip_entice_split_helpdesk: "Search help center",
            tooltip_entice_split_chat: "Chat"
        },
        chat: {
            minimized_tooltip_message_from: "Message from",
            minimized_connect_alert_failure: "Failed to connect. Messaging may be unavailable at the moment.",
            chat_header_ongoing_from: "from",
            chat_header_ongoing_status_metrics: "Typically replies under %1s",
            chat_header_ongoing_status_last: "Was last active %1s",
            chat_header_ongoing_status_online: "Support is online",
            chat_header_ongoing_status_away: "Support is away",
            chat_alerts_new_messages: "There are new messages below. Click to see.",
            chat_alerts_email_invalid: "You mistyped your email, can you check it?",
            chat_alerts_wait_reply_online: "Thanks! We should reply in a few moments.",
            chat_alerts_wait_reply_away: "We are not online. We will email you back.",
            chat_pickers_selector_smileys: "Smileys",
            chat_pickers_selector_gifs: "GIFs",
            chat_pickers_gif_search: "Find GIFs...",
            chat_pickers_gif_no_results: "No results. Try another search.",
            chat_message_file_name: "Attached file",
            chat_message_file_video: "Play video",
            chat_message_file_download: "Download file",
            chat_message_tag_participant: "Participant",
            chat_message_tag_edited: "Edited",
            chat_message_tag_translated: "Translated",
            chat_message_info_read: "Read",
            chat_message_error_retry: "Failed to send. Retry?",
            chat_message_send_abort_warn: "Some messages have not yet been sent. Navigating will prevent them from being sent.",
            chat_form_field_message: "Compose your message...",
            chat_form_field_disabled: "Messaging is unavailable.",
            chat_form_smiley_tooltip: "Insert an emoji",
            chat_form_attach_tooltip: "Send a file",
            chat_form_attach_alert_quota: "Daily file upload quota has been exceeded, or file extension is not allowed.",
            chat_form_attach_alert_size: "File too large. Please reduce its size and try again.",
            chat_form_attach_alert_error: "An error occured while uploading the file. Please try again.",
            chat_form_attach_abort_warn: "Navigating when a file is being uploaded will stop upload.",
            minimized_tooltip_message_compose: "Compose your reply...",
            chat_game_controls_stop: "Stop playing",
            chat_header_ongoing_channel_continue: "Continue on %1s",
            chat_header_ongoing_channel_continue_email: "Email",
            chat_message_text_identity_main: "Just in case you leave or we reply later:",
            chat_message_text_identity_ask: "how do you want us to get back to you?",
            chat_message_text_identity_pick_email: "Email",
            chat_message_text_identity_pick_phone: "Phone",
            chat_message_text_identity_ask_email: "What is your email address?",
            chat_message_text_identity_ask_field_email: "Enter your email address...",
            chat_message_text_identity_ask_phone: "What is your phone number?",
            chat_message_text_identity_ask_field_phone: "Enter your phone number...",
            chat_message_text_identity_ask_field_submit: "OK",
            chat_message_text_game_main: "Looks like we are taking time to reply.",
            chat_message_text_game_ask: "While you wait, want to play a cool game?",
            chat_message_text_game_pick_yes: "Play a game",
            chat_message_text_game_pick_no: "No, thanks",
            chat_message_audio_play_error: "Could not play this audio file. It may have expired.",
            chat_alerts_warn_reply_email_default: "Click to set your email to get notifications.",
            chat_alerts_warn_reply_email_force: "Please set your email to continue.",
            chat_alerts_warn_reply_phone_default: "Click to set your phone to get notifications.",
            chat_alerts_warn_reply_phone_force: "Please set your phone to continue.",
            chat_welcome_helpdesk: "Search on Helpdesk",
            chat_header_ongoing_channel_continue_phone: "Phone",
            chat_offline_main: "Network offline. Reconnecting...",
            chat_offline_inactive: "Offline. You were inactive for some time.",
            chat_offline_fail: "Offline. Please reload the page.",
            chat_offline_label_frozen: "No messages can be received or sent for now.",
            chat_offline_label_resume: "Send a message to reconnect to the chat.",
            chat_health_main: "Some of our services are not working.",
            chat_health_label_link: "See our status page",
            chat_health_label_updates: "for more updates.",
            chat_form_attach_confirm_upload: "Upload this pasted file?"
        },
        article: {
            controls_close: "Close article",
            controls_view: "View in Helpdesk"
        },
        spotlight: {
            search_form_field: "Search our help center...",
            action_close: "Close search",
            action_open: "Open Helpdesk",
            result_view: "View",
            result_empty: "Sorry, no search results were found. Try with another keyword."
        },
        call: {
            ring_title_website: "%1s support",
            ring_title_label: "%1s is calling you...",
            ring_actions_decline: "Decline",
            ring_actions_accept: "Accept",
            screen_label_audio_muted: "Audio muted",
            screen_label_video_muted: "Video muted",
            screen_status_connecting: "Connecting...",
            screen_status_ongoing: "Ongoing",
            call_abort_warn: "Navigating when a call is ongoing will stop the call."
        },
        browsing: {
            assist_mouse_tooltip: "%1s is assisting you"
        }
    }
});